    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Beauty Bawl — {{ config('app.name', 'Laravel') }}</title>
        <meta name="description" content="Beauty Bawl — curated personal & family beauty products and tools. Shop skincare, haircare, makeup and professional tools. Secure checkout with Stripe + M-Pesa integrations." />
        <link rel="canonical" href="{{ url()->current() }}" />
        <meta name="robots" content="index,follow" />

        <!-- Open Graph / Social -->
        <meta property="og:site_name" content="{{ config('app.name', 'Laravel') }}" />
        <meta property="og:type" content="website" />
        <meta property="og:title" content="Beauty Bawl — Personal & Family Beauty Products" />
        <meta property="og:description" content="Curated beauty products and tools for personal and family use. Fast, secure checkout via Stripe and M-Pesa." />
        <meta property="og:url" content="{{ url()->current() }}" />
        <meta name="twitter:card" content="summary_large_image" />

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

        <!-- Styles / Scripts -->
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <!-- Tailwind CSS CDN for styling -->
            <script src="https://cdn.tailwindcss.com"></script>
            <script>
                tailwind.config = {
                    darkMode: 'class',
                    theme: {
                        extend: {
                            colors: {
                                primary: {
                                    50: '#fdf2f8',
                                    100: '#fce7f3',
                                    500: '#ec4899',
                                    600: '#db2777',
                                    700: '#be185d',
                                }
                            }
                        }
                    }
                }
            </script>
        @endif

        <!-- JSON-LD structured data for SEO -->
        <script type="application/ld+json">
        @verbatim
        {
            "@context": "https://schema.org",
            "@type": "WebSite",
            "name": "Beauty Bawl",
            "url": "{{ url('/') }}",
            "potentialAction": {
                "@type": "SearchAction",
                "target": "{{ url('/search') }}?q={search_term_string}",
                "query-input": "required name=search_term_string"
            }
        }
        @endverbatim
        </script>
        <script type="application/ld+json">
        @verbatim
        {
            "@context": "https://schema.org",
            "@type": "Organization",
            "name": "Beauty Bawl",
            "url": "{{ url('/') }}",
            "logo": "{{ url('/logo.png') }}",
            "sameAs": []
        }
        @endverbatim
        </script>
    <body class="bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:bg-gradient-to-br dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 text-gray-900 dark:text-gray-100 antialiased min-h-screen">
        <!-- Top Announcement Bar -->
        <div class="bg-gradient-to-r from-pink-600 to-purple-600 text-white text-center py-2 px-4">
            <p class="text-sm font-medium">✨ Get 10% off your first order with code: <span class="font-bold">BEAUTY10</span></p>
        </div>

        <!-- Main Header -->
        <header class="bg-white/90 dark:bg-gray-900/90 backdrop-blur-md shadow-sm sticky top-0 z-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-wrap justify-between items-center py-4 gap-4">
                    <!-- Logo & Brand -->
                    <div class="flex items-center gap-6">
                        <a href="{{ url('/') }}" class="flex items-center gap-3 group">
                            <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-500 rounded-xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                </svg>
                            </div>
                            <span class="font-bold text-2xl bg-gradient-to-r from-pink-600 to-purple-600 bg-clip-text text-transparent">Beauty Bawl</span>
                        </a>
                        
                        <nav class="hidden lg:flex items-center gap-6 text-sm font-medium">
                            <a href="#categories" class="text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Categories</a>
                            <a href="#featured" class="text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Featured</a>
                            <a href="#brands" class="text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Brands</a>
                            <a href="#deals" class="text-pink-600 dark:text-pink-400 font-semibold">🔥 Deals</a>
                        </nav>
                    </div>

                    <!-- Search Bar -->
                    <div class="flex items-center gap-4 flex-1 max-w-xl">
                        <form action="{{ url('/search') }}" method="GET" class="flex-1 flex items-center bg-gray-100 dark:bg-gray-800 rounded-full overflow-hidden shadow-md hover:shadow-lg transition-shadow">
                            <input name="q" placeholder="Search skincare, makeup, tools..." aria-label="Search products" class="px-6 py-3 flex-1 bg-transparent text-sm focus:outline-none" />
                            <button type="submit" class="px-6 py-3 bg-gradient-to-r from-pink-600 to-purple-600 text-white font-medium hover:from-pink-700 hover:to-purple-700 transition-all">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </button>
                        </form>
                    </div>

                    <!-- User Actions -->
                    <div class="flex items-center gap-3">
                        @if (Route::has('login'))
                            @auth
                                <a href="{{ url('/dashboard') }}" class="hidden sm:flex items-center gap-2 px-4 py-2 bg-gray-100 dark:bg-gray-800 rounded-full hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                    </svg>
                                    <span class="text-sm font-medium">Dashboard</span>
                                </a>
                            @else
                                <a href="{{ route('login') }}" class="text-sm font-medium px-4 py-2 hover:text-pink-600 transition-colors">Log in</a>
                                @if (Route::has('register'))
                                    <a href="{{ route('register') }}" class="px-6 py-2 bg-gradient-to-r from-pink-600 to-purple-600 text-white text-sm font-medium rounded-full shadow-md hover:shadow-lg transform hover:-translate-y-0.5 transition-all">
                                        Register
                                    </a>
                                @endif
                            @endauth
                        @endif
                        
                        <button class="relative p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-full transition-colors">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                            <span class="absolute top-0 right-0 w-5 h-5 bg-pink-600 text-white text-xs flex items-center justify-center rounded-full">0</span>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        <!-- Hero Section -->
        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8" role="main">
            <section class="relative overflow-hidden rounded-3xl bg-gradient-to-r from-pink-600 via-purple-600 to-indigo-600 p-8 md:p-16 mb-12 shadow-2xl">
                <!-- Decorative Elements -->
                <div class="absolute top-0 right-0 w-96 h-96 bg-white/10 rounded-full blur-3xl"></div>
                <div class="absolute bottom-0 left-0 w-64 h-64 bg-pink-300/20 rounded-full blur-3xl"></div>
                
                <div class="relative z-10 grid md:grid-cols-2 gap-8 items-center">
                    <div class="text-white">
                        <div class="inline-block px-4 py-2 bg-white/20 backdrop-blur-sm rounded-full text-sm font-medium mb-4">
                            ✨ Free Shipping on Orders Over $50
                        </div>
                        <h1 class="text-4xl md:text-6xl font-extrabold mb-6 leading-tight">
                            Beauty for Home & Family
                        </h1>
                        <p class="text-lg md:text-xl text-white/90 mb-8 leading-relaxed">
                            Discover curated skincare, makeup, and professional tools designed for personal and family beauty needs. Shop with confidence using Stripe and M-Pesa.
                        </p>
                        
                        <div class="flex flex-wrap gap-4">
                            <a href="#featured" class="inline-flex items-center gap-2 px-8 py-4 bg-white text-pink-600 rounded-full font-bold shadow-xl hover:scale-105 transform transition-all">
                                <span>Shop Now</span>
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </a>
                            <a href="#categories" class="inline-flex items-center gap-2 px-8 py-4 bg-white/10 backdrop-blur-sm text-white rounded-full font-bold border-2 border-white/30 hover:bg-white/20 transition-all">
                                Browse Categories
                            </a>
                        </div>

                        <!-- Trust Badges -->
                        <div class="flex flex-wrap gap-6 mt-8 pt-8 border-t border-white/20">
                            <div class="flex items-center gap-2 text-white/90">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                </svg>
                                <span class="text-sm font-medium">Secure Checkout</span>
                            </div>
                            <div class="flex items-center gap-2 text-white/90">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                <span class="text-sm font-medium">Family-Safe Products</span>
                            </div>
                            <div class="flex items-center gap-2 text-white/90">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                </svg>
                                <span class="text-sm font-medium">Fast Delivery</span>
                            </div>
                        </div>
                    </div>

                    <div class="hidden md:block">
                        <div class="relative">
                            <!-- Placeholder for hero image - replace with actual product images -->
                            <div class="aspect-square rounded-2xl bg-white/10 backdrop-blur-lg border border-white/20 shadow-2xl p-8 flex items-center justify-center">
                                <svg class="w-full h-full text-white/30" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="0.5" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Categories Section -->
            <section id="categories" class="mb-12">
                <div class="text-center mb-8">
                    <h2 class="text-3xl md:text-4xl font-bold mb-3">Shop by Category</h2>
                    <p class="text-gray-600 dark:text-gray-400">Explore our curated collections</p>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-6">
                    <a href="/category/skincare" class="group relative overflow-hidden rounded-2xl bg-gradient-to-br from-pink-100 to-pink-200 dark:from-pink-900/30 dark:to-pink-800/30 p-8 text-center hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                        <div class="absolute inset-0 bg-gradient-to-br from-pink-500/0 to-pink-500/0 group-hover:from-pink-500/20 group-hover:to-pink-500/10 transition-all"></div>
                        <div class="relative">
                            <div class="w-16 h-16 mx-auto mb-4 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                <svg class="w-8 h-8 text-pink-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c1.104 0 2-.896 2-2s-.896-2-2-2-2 .896-2 2 .896 2 2 2z"/>
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg mb-1">Skincare</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Premium formulas</p>
                        </div>
                    </a>

                    <a href="/category/haircare" class="group relative overflow-hidden rounded-2xl bg-gradient-to-br from-amber-100 to-amber-200 dark:from-amber-900/30 dark:to-amber-800/30 p-8 text-center hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                        <div class="absolute inset-0 bg-gradient-to-br from-amber-500/0 to-amber-500/0 group-hover:from-amber-500/20 group-hover:to-amber-500/10 transition-all"></div>
                        <div class="relative">
                            <div class="w-16 h-16 mx-auto mb-4 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                <svg class="w-8 h-8 text-amber-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v18"/>
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg mb-1">Haircare</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Salon quality</p>
                        </div>
                    </a>

                    <a href="/category/makeup" class="group relative overflow-hidden rounded-2xl bg-gradient-to-br from-purple-100 to-purple-200 dark:from-purple-900/30 dark:to-purple-800/30 p-8 text-center hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                        <div class="absolute inset-0 bg-gradient-to-br from-purple-500/0 to-purple-500/0 group-hover:from-purple-500/20 group-hover:to-purple-500/10 transition-all"></div>
                        <div class="relative">
                            <div class="w-16 h-16 mx-auto mb-4 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                <svg class="w-8 h-8 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01"/>
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg mb-1">Makeup</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Professional grade</p>
                        </div>
                    </a>

                    <a href="/category/tools" class="group relative overflow-hidden rounded-2xl bg-gradient-to-br from-gray-100 to-gray-200 dark:from-gray-700/30 dark:to-gray-600/30 p-8 text-center hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300">
                        <div class="absolute inset-0 bg-gradient-to-br from-gray-500/0 to-gray-500/0 group-hover:from-gray-500/20 group-hover:to-gray-500/10 transition-all"></div>
                        <div class="relative">
                            <div class="w-16 h-16 mx-auto mb-4 bg-white dark:bg-gray-800 rounded-2xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                <svg class="w-8 h-8 text-gray-700" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                            </div>
                            <h3 class="font-bold text-lg mb-1">Tools</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Beauty devices</p>
                        </div>
                    </a>
                </div>
            </section>

            <!-- Featured Products Section -->
            <section id="featured" class="mb-12">
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h2 class="text-3xl font-bold mb-2">Featured Products</h2>
                        <p class="text-gray-600 dark:text-gray-400">Handpicked favorites for you</p>
                    </div>
                    <a href="/shop" class="inline-flex items-center gap-2 px-6 py-3 bg-gradient-to-r from-pink-600 to-purple-600 text-white rounded-full font-medium hover:shadow-lg transform hover:-translate-y-0.5 transition-all">
                        <span>View All</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                        </svg>
                    </a>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6" aria-live="polite">
                    @foreach (range(1,8) as $i)
                        <article class="group bg-white dark:bg-gray-800 rounded-2xl shadow-lg hover:shadow-2xl transform hover:-translate-y-2 transition-all duration-300 overflow-hidden" itemscope itemtype="https://schema.org/Product">
                            <a href="/product/sample-{{ $i }}" class="block" itemprop="url">
                                <!-- Product Image -->
                                <div class="relative aspect-square bg-gradient-to-br from-gray-100 to-gray-200 dark:from-gray-700 dark:to-gray-600 overflow-hidden">
                                    <div class="absolute inset-0 flex items-center justify-center">
                                        <svg class="w-24 h-24 text-gray-300 dark:text-gray-600" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                        </svg>
                                    </div>
                                    
                                    <!-- Badges -->
                                    <div class="absolute top-3 left-3 flex flex-col gap-2">
                                        @if($i % 3 == 0)
                                            <span class="px-3 py-1 bg-pink-600 text-white text-xs font-bold rounded-full shadow">NEW</span>
                                        @endif
                                        @if($i % 4 == 0)
                                            <span class="px-3 py-1 bg-green-600 text-white text-xs font-bold rounded-full shadow">ECO</span>
                                        @endif
                                    </div>
                                    
                                    <!-- Wishlist Button -->
                                    <button class="absolute top-3 right-3 w-10 h-10 bg-white/90 dark:bg-gray-800/90 backdrop-blur-sm rounded-full flex items-center justify-center hover:scale-110 transition-transform shadow-lg" aria-label="Add to wishlist">
                                        <svg class="w-5 h-5 text-gray-600 dark:text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                        </svg>
                                    </button>
                                </div>

                                <!-- Product Info -->
                                <div class="p-5">
                                    <!-- Rating -->
                                    <div class="flex items-center gap-1 mb-2">
                                        @for($star = 0; $star < 5; $star++)
                                            <svg class="w-4 h-4 {{ $star < 4 ? 'text-yellow-400' : 'text-gray-300' }}" fill="currentColor" viewBox="0 0 20 20">
                                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                            </svg>
                                        @endfor
                                        <span class="text-xs text-gray-500 ml-1">({{ 20 + $i * 5 }})</span>
                                    </div>

                                    <!-- Product Name -->
                                    <h3 class="font-bold text-gray-900 dark:text-gray-100 mb-1 line-clamp-2 group-hover:text-pink-600 transition-colors" itemprop="name">
                                        Premium Beauty Product {{ $i }}
                                    </h3>
                                    
                                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-3">Gentle formula • 100ml</p>

                                    <!-- Price & Action -->
                                    <div class="flex items-center justify-between">
                                        <div itemprop="offers" itemscope itemtype="https://schema.org/Offer">
                                            <div class="flex items-baseline gap-2">
                                                <span class="text-2xl font-bold text-pink-600" itemprop="price">
                                                    <span itemprop="priceCurrency" content="USD">$</span>{{ sprintf('%.2f', 15 + $i * 5) }}
                                                </span>
                                                @if($i % 2 == 0)
                                                    <span class="text-sm text-gray-400 line-through">${{ sprintf('%.2f', 20 + $i * 5) }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        
                                        <button class="w-10 h-10 bg-gradient-to-r from-pink-600 to-purple-600 text-white rounded-full flex items-center justify-center hover:scale-110 hover:shadow-lg transition-all" aria-label="Add Premium Beauty Product {{ $i }} to cart">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </a>
                        </article>
                    @endforeach
                </div>
            </section>

            <!-- Newsletter Section -->
            <section id="newsletter" class="mb-12 relative overflow-hidden rounded-3xl bg-gradient-to-r from-purple-600 via-pink-600 to-red-600 p-12 shadow-2xl">
                <!-- Decorative Elements -->
                <div class="absolute top-0 right-0 w-96 h-96 bg-white/10 rounded-full blur-3xl"></div>
                <div class="absolute bottom-0 left-0 w-64 h-64 bg-pink-300/20 rounded-full blur-3xl"></div>
                
                <div class="relative z-10 max-w-3xl mx-auto text-center text-white">
                    <div class="inline-block p-3 bg-white/20 backdrop-blur-sm rounded-2xl mb-6">
                        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                        </svg>
                    </div>
                    
                    <h3 class="text-3xl md:text-4xl font-bold mb-4">Join Our Beauty Community</h3>
                    <p class="text-lg text-white/90 mb-8">
                        Get exclusive beauty tips, early access to new products, and 10% off your first order
                    </p>
                    
                    <form action="/newsletter" method="POST" class="flex flex-col sm:flex-row gap-3 max-w-md mx-auto">
                        @csrf
                        <input type="email" name="email" placeholder="Enter your email" required 
                            class="flex-1 px-6 py-4 rounded-full text-gray-900 font-medium focus:outline-none focus:ring-4 focus:ring-white/30 shadow-lg" />
                        <button class="px-8 py-4 bg-white text-pink-600 rounded-full font-bold shadow-xl hover:scale-105 transform transition-all whitespace-nowrap">
                            Subscribe Now
                        </button>
                    </form>
                    
                    <p class="text-sm text-white/70 mt-4">
                        🔒 We respect your privacy. Unsubscribe anytime.
                    </p>
                </div>
            </section>

        </main>

        <!-- Footer -->
        <footer class="bg-gray-900 text-gray-300">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-8">
                    <!-- Brand Column -->
                    <div class="lg:col-span-1">
                        <a href="/" class="flex items-center gap-3 mb-4 group">
                            <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-500 rounded-xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                </svg>
                            </div>
                            <span class="font-bold text-xl text-white">Beauty Bawl</span>
                        </a>
                        <p class="text-sm mb-4">
                            Premium beauty products for personal and family care. Trusted by thousands of happy customers.
                        </p>
                        
                        <!-- Social Links -->
                        <div class="flex gap-3">
                            <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-600 rounded-full flex items-center justify-center transition-colors" aria-label="Facebook">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-600 rounded-full flex items-center justify-center transition-colors" aria-label="Instagram">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-600 rounded-full flex items-center justify-center transition-colors" aria-label="Twitter">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                                </svg>
                            </a>
                        </div>
                    </div>

                    <!-- Shop Column -->
                    <div>
                        <h4 class="font-bold text-white mb-4">Shop</h4>
                        <ul class="space-y-2 text-sm">
                            <li><a href="/category/skincare" class="hover:text-pink-400 transition-colors">Skincare</a></li>
                            <li><a href="/category/haircare" class="hover:text-pink-400 transition-colors">Haircare</a></li>
                            <li><a href="/category/makeup" class="hover:text-pink-400 transition-colors">Makeup</a></li>
                            <li><a href="/category/tools" class="hover:text-pink-400 transition-colors">Beauty Tools</a></li>
                            <li><a href="/deals" class="hover:text-pink-400 transition-colors">Special Deals</a></li>
                        </ul>
                    </div>

                    <!-- Customer Service Column -->
                    <div>
                        <h4 class="font-bold text-white mb-4">Customer Service</h4>
                        <ul class="space-y-2 text-sm">
                            <li><a href="/about" class="hover:text-pink-400 transition-colors">About Us</a></li>
                            <li><a href="/contact" class="hover:text-pink-400 transition-colors">Contact</a></li>
                            <li><a href="/shipping" class="hover:text-pink-400 transition-colors">Shipping Info</a></li>
                            <li><a href="/returns" class="hover:text-pink-400 transition-colors">Returns & Refunds</a></li>
                            <li><a href="/faq" class="hover:text-pink-400 transition-colors">FAQs</a></li>
                        </ul>
                    </div>

                    <!-- Legal Column -->
                    <div>
                        <h4 class="font-bold text-white mb-4">Legal</h4>
                        <ul class="space-y-2 text-sm">
                            <li><a href="/privacy" class="hover:text-pink-400 transition-colors">Privacy Policy</a></li>
                            <li><a href="/terms" class="hover:text-pink-400 transition-colors">Terms of Service</a></li>
                            <li><a href="/cookies" class="hover:text-pink-400 transition-colors">Cookie Policy</a></li>
                        </ul>
                        
                        <div class="mt-6 pt-6 border-t border-gray-800">
                            <h4 class="font-bold text-white mb-3">Payment Methods</h4>
                            <div class="flex gap-2 flex-wrap">
                                <div class="px-3 py-1 bg-gray-800 rounded text-xs font-medium">Stripe</div>
                                <div class="px-3 py-1 bg-gray-800 rounded text-xs font-medium">M-Pesa</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer Bottom -->
                <div class="pt-8 border-t border-gray-800 flex flex-col md:flex-row justify-between items-center gap-4">
                    <p class="text-sm text-gray-500">
                        © {{ date('Y') }} Beauty Bawl. All rights reserved.
                    </p>
                    <div class="flex items-center gap-2 text-sm text-gray-500">
                        <svg class="w-5 h-5 text-pink-500" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 17.657l-6.828-6.829a4 4 0 010-5.656z" clip-rule="evenodd" />
                        </svg>
                        <span>Made with love for beautiful families</span>
                    </div>
                </div>
            </div>
        </footer>

        <!-- Payment integration note: Stripe + M-Pesa wiring will be implemented server-side and via JS SDKs on checkout pages. -->
    </body>
</html>

