<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Shipping Information - Beauty Bawl</title>
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:from-gray-900 dark:to-gray-900 text-gray-900 dark:text-gray-100">
        @include('partials.header')
        <main class="max-w-4xl mx-auto px-4 py-12">
            <h1 class="text-5xl font-bold mb-6">Shipping Information</h1>
            <p class="text-xl text-gray-600 dark:text-gray-400 mb-12">Fast, reliable delivery to your doorstep</p>

            <div class="space-y-8">
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">Shipping Methods</h2>
                    <div class="space-y-6">
                        <div class="flex gap-4 p-4 bg-gradient-to-r from-pink-50 to-purple-50 dark:from-pink-900/20 dark:to-purple-900/20 rounded-xl">
                            <div class="w-12 h-12 bg-pink-600 text-white rounded-xl flex items-center justify-center shrink-0 font-bold">🚚</div>
                            <div><h3 class="font-bold mb-1">Standard Shipping (3-5 business days)</h3>
                            <p class="text-gray-600 dark:text-gray-400">Free on orders over $50, otherwise $5.99</p></div>
                        </div>
                        <div class="flex gap-4 p-4 bg-gradient-to-r from-purple-50 to-pink-50 dark:from-purple-900/20 dark:to-pink-900/20 rounded-xl">
                            <div class="w-12 h-12 bg-purple-600 text-white rounded-xl flex items-center justify-center shrink-0 font-bold">⚡</div>
                            <div><h3 class="font-bold mb-1">Express Shipping (1-2 business days)</h3>
                            <p class="text-gray-600 dark:text-gray-400">$14.99 flat rate</p></div>
                        </div>
                    </div>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">Processing Time</h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Orders are processed within 1-2 business days. You'll receive a tracking number via email once your order ships.</p>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">International Shipping</h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">We currently ship to Kenya, East Africa, and select international destinations. Delivery times vary by location (7-14 business days). International orders may be subject to customs fees.</p>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold mb-4">Order Tracking</h2>
                    <p class="text-gray-600 dark:text-gray-400 mb-4">Track your order anytime using the tracking link sent to your email. Contact support if you need assistance.</p>
                </div>
            </div>
        </main>
        @include('partials.footer')
    </body>
</html>
