<!-- Top Announcement Bar -->
<div class="bg-gradient-to-r from-pink-600 to-purple-600 text-white text-center py-2 px-4">
    <p class="text-sm font-medium">✨ Get 10% off your first order with code: <span class="font-bold">BEAUTY10</span></p>
</div>

<!-- Main Header -->
<header class="bg-white/95 dark:bg-gray-900/95 backdrop-blur-md shadow-md sticky top-0 z-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Top Row: Logo, Search, Actions -->
        <div class="flex items-center justify-between py-4 gap-4">
            <!-- Logo -->
            <a href="{{ url('/') }}" class="flex items-center gap-3 group flex-shrink-0">
                <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-500 rounded-xl flex items-center justify-center shadow-lg group-hover:scale-110 transition-transform">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                    </svg>
                </div>
                <span class="hidden sm:block font-bold text-xl lg:text-2xl bg-gradient-to-r from-pink-600 to-purple-600 bg-clip-text text-transparent">Beauty Bawl</span>
            </a>

            <!-- Search Bar (Desktop) -->
            <div class="hidden md:flex flex-1 max-w-2xl mx-8">
                <form action="{{ url('/search') }}" method="GET" class="w-full relative">
                    <input 
                        type="text" 
                        name="q" 
                        placeholder="Search for products, brands, or categories..." 
                        class="w-full px-6 py-3 pr-12 bg-gray-100 dark:bg-gray-800 rounded-full text-sm focus:outline-none focus:ring-2 focus:ring-pink-500 focus:bg-white dark:focus:bg-gray-700 transition-all" 
                    />
                    <button type="submit" class="absolute right-2 top-1/2 -translate-y-1/2 p-2 bg-gradient-to-r from-pink-600 to-purple-600 text-white rounded-full hover:shadow-lg transition-all">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                </form>
            </div>

            <!-- User Actions -->
            <div class="flex items-center gap-2 lg:gap-3 flex-shrink-0">
                @if (Route::has('login'))
                    @auth
                        <a href="{{ url('/dashboard') }}" class="hidden lg:flex items-center gap-2 px-4 py-2 bg-gray-100 dark:bg-gray-800 rounded-full hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                            <span class="text-sm font-medium">Account</span>
                        </a>
                    @else
                        <a href="{{ route('login') }}" class="hidden sm:block text-sm font-medium px-4 py-2 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Log in</a>
                        @if (Route::has('register'))
                            <a href="{{ route('register') }}" class="hidden sm:flex items-center gap-1 px-4 lg:px-6 py-2 bg-gradient-to-r from-pink-600 to-purple-600 text-white text-sm font-medium rounded-full shadow-md hover:shadow-lg transform hover:-translate-y-0.5 transition-all">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" />
                                </svg>
                                <span>Register</span>
                            </a>
                        @endif
                    @endauth
                @endif

                <!-- Wishlist -->
                <button class="hidden sm:block relative p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-full transition-colors" title="Wishlist">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                    </svg>
                    <span class="absolute top-0 right-0 w-5 h-5 bg-pink-600 text-white text-xs flex items-center justify-center rounded-full font-medium">5</span>
                </button>
                
                <!-- Cart -->
                <a href="{{ url('/cart') }}" class="relative p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-full transition-colors group" title="Shopping Cart">
                    <svg class="w-6 h-6 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                    <span class="absolute top-0 right-0 w-5 h-5 bg-gradient-to-r from-pink-600 to-purple-600 text-white text-xs flex items-center justify-center rounded-full font-bold shadow-md">3</span>
                </a>

                <!-- Mobile Menu Toggle -->
                <button id="mobile-menu-toggle" class="lg:hidden p-2 hover:bg-gray-100 dark:hover:bg-gray-800 rounded-lg transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>

        <!-- Navigation Bar (Desktop) -->
        <nav class="hidden lg:flex items-center justify-between border-t border-gray-200 dark:border-gray-700 py-3">
            <div class="flex items-center gap-8">
                <!-- Categories Dropdown -->
                <div class="relative group">
                    <button class="flex items-center gap-2 text-sm font-semibold text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors py-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                        <span>Categories</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    
                    <!-- Mega Menu -->
                    <div class="absolute left-0 top-full mt-2 w-96 bg-white dark:bg-gray-800 rounded-2xl shadow-2xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 border border-gray-100 dark:border-gray-700">
                        <div class="p-6 grid grid-cols-2 gap-4">
                            <a href="{{ route('category', 'skincare') }}" class="flex items-center gap-3 p-3 rounded-xl hover:bg-pink-50 dark:hover:bg-gray-700 transition-colors group/item">
                                <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-purple-500 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-sm text-gray-900 dark:text-white">Skincare</h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Cleansers, Serums</p>
                                </div>
                            </a>

                            <a href="{{ route('category', 'haircare') }}" class="flex items-center gap-3 p-3 rounded-xl hover:bg-pink-50 dark:hover:bg-gray-700 transition-colors group/item">
                                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-500 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-sm text-gray-900 dark:text-white">Hair Care</h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Shampoos, Oils</p>
                                </div>
                            </a>

                            <a href="{{ route('category', 'makeup') }}" class="flex items-center gap-3 p-3 rounded-xl hover:bg-pink-50 dark:hover:bg-gray-700 transition-colors group/item">
                                <div class="w-12 h-12 bg-gradient-to-br from-pink-500 to-red-500 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-sm text-gray-900 dark:text-white">Makeup</h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Lipsticks, Foundations</p>
                                </div>
                            </a>

                            <a href="{{ route('category', 'tools') }}" class="flex items-center gap-3 p-3 rounded-xl hover:bg-pink-50 dark:hover:bg-gray-700 transition-colors group/item">
                                <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-indigo-500 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-sm text-gray-900 dark:text-white">Tools</h3>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">Brushes, Sponges</p>
                                </div>
                            </a>
                        </div>

                        <div class="px-6 py-4 bg-gradient-to-r from-pink-50 to-purple-50 dark:from-gray-700 dark:to-gray-700 rounded-b-2xl border-t border-gray-100 dark:border-gray-600">
                            <a href="{{ route('shop') }}" class="flex items-center justify-between text-sm font-semibold text-pink-600 dark:text-pink-400 hover:text-pink-700 dark:hover:text-pink-300">
                                <span>View All Products</span>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Featured -->
                <a href="{{ route('featured') }}" class="text-sm font-medium text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Featured</a>

                <!-- Brands Dropdown -->
                <div class="relative group">
                    <button class="flex items-center gap-1 text-sm font-medium text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">
                        <span>Brands</span>
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    
                    <div class="absolute left-0 top-full mt-2 w-64 bg-white dark:bg-gray-800 rounded-xl shadow-2xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 border border-gray-100 dark:border-gray-700">
                        <div class="p-4 space-y-2">
                            <a href="{{ route('brand', 'cerave') }}" class="block px-4 py-2 rounded-lg hover:bg-pink-50 dark:hover:bg-gray-700 text-sm font-medium transition-colors">CeraVe</a>
                            <a href="{{ route('brand', 'loreal') }}" class="block px-4 py-2 rounded-lg hover:bg-pink-50 dark:hover:bg-gray-700 text-sm font-medium transition-colors">L'Oréal</a>
                            <a href="{{ route('brand', 'neutrogena') }}" class="block px-4 py-2 rounded-lg hover:bg-pink-50 dark:hover:bg-gray-700 text-sm font-medium transition-colors">Neutrogena</a>
                            <a href="{{ route('brand', 'maybelline') }}" class="block px-4 py-2 rounded-lg hover:bg-pink-50 dark:hover:bg-gray-700 text-sm font-medium transition-colors">Maybelline</a>
                            <a href="{{ route('brand', 'nivea') }}" class="block px-4 py-2 rounded-lg hover:bg-pink-50 dark:hover:bg-gray-700 text-sm font-medium transition-colors">Nivea</a>
                            <a href="{{ route('brand', 'garnier') }}" class="block px-4 py-2 rounded-lg hover:bg-pink-50 dark:hover:bg-gray-700 text-sm font-medium transition-colors">Garnier</a>
                        </div>
                        <div class="px-4 py-3 border-t border-gray-100 dark:border-gray-700">
                            <a href="{{ route('brands') }}" class="flex items-center justify-between text-sm font-semibold text-pink-600 dark:text-pink-400 hover:text-pink-700">
                                <span>All Brands</span>
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Deals -->
                <a href="{{ route('deals') }}" class="flex items-center gap-2 text-sm font-bold text-pink-600 dark:text-pink-400 hover:text-pink-700 dark:hover:text-pink-300 transition-colors">
                    <span class="text-lg">🔥</span>
                    <span>Deals</span>
                    <span class="px-2 py-0.5 bg-pink-600 text-white text-xs rounded-full font-bold">HOT</span>
                </a>
            </div>

            <!-- Right Side Links -->
            <div class="flex items-center gap-6 text-sm">
                <a href="{{ url('/about') }}" class="text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">About</a>
                <a href="{{ url('/contact') }}" class="text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Contact</a>
                <a href="{{ url('/faq') }}" class="text-gray-700 dark:text-gray-300 hover:text-pink-600 dark:hover:text-pink-400 transition-colors">Help</a>
            </div>
        </nav>

        <!-- Mobile Search Bar -->
        <div class="md:hidden pb-4">
            <form action="{{ url('/search') }}" method="GET" class="relative">
                <input 
                    type="text" 
                    name="q" 
                    placeholder="Search products..." 
                    class="w-full px-4 py-3 pr-12 bg-gray-100 dark:bg-gray-800 rounded-full text-sm focus:outline-none focus:ring-2 focus:ring-pink-500" 
                />
                <button type="submit" class="absolute right-2 top-1/2 -translate-y-1/2 p-2 bg-gradient-to-r from-pink-600 to-purple-600 text-white rounded-full">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                    </svg>
                </button>
            </form>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="lg:hidden hidden bg-white dark:bg-gray-900 border-t border-gray-200 dark:border-gray-700">
        <nav class="max-w-7xl mx-auto px-4 py-4 space-y-1">
            <a href="{{ route('shop') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 font-medium transition-colors">All Products</a>
            <a href="{{ route('category', 'skincare') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Skincare</a>
            <a href="{{ route('category', 'haircare') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Hair Care</a>
            <a href="{{ route('category', 'makeup') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Makeup</a>
            <a href="{{ route('category', 'tools') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Tools & Accessories</a>
            <a href="{{ route('featured') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Featured Products</a>
            <a href="{{ route('deals') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 text-pink-600 dark:text-pink-400 font-semibold transition-colors">🔥 Hot Deals</a>
            <hr class="my-2 border-gray-200 dark:border-gray-700">
            <a href="{{ route('about') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">About Us</a>
            <a href="{{ route('contact') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Contact</a>
            <a href="{{ route('faq') }}" class="block px-4 py-3 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">Help & FAQ</a>
        </nav>
    </div>
</header>

<script>
    // Mobile menu toggle
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const mobileMenu = document.getElementById('mobile-menu');
        
        if (mobileMenuToggle && mobileMenu) {
            mobileMenuToggle.addEventListener('click', function() {
                mobileMenu.classList.toggle('hidden');
            });
        }
    });
</script>
