<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Checkout - Beauty Bawl</title>
        
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        
        @if (file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot')))
            @vite(['resources/css/app.css', 'resources/js/app.js'])
        @else
            <script src="https://cdn.tailwindcss.com"></script>
        @endif
    </head>
    <body class="bg-gradient-to-br from-pink-50 via-white to-purple-50 dark:bg-gradient-to-br dark:from-gray-900 dark:via-gray-800 dark:to-gray-900 text-gray-900 dark:text-gray-100 antialiased">
        
        @include('partials.header')

        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <h1 class="text-4xl font-bold mb-8">Secure Checkout</h1>

            <div class="grid lg:grid-cols-3 gap-8">
                <!-- Checkout Form -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Shipping Information -->
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                        <h2 class="text-2xl font-bold mb-6 flex items-center gap-2">
                            <span class="w-8 h-8 bg-pink-600 text-white rounded-full flex items-center justify-center text-sm font-bold">1</span>
                            Shipping Information
                        </h2>

                        <form class="grid md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium mb-2">First Name *</label>
                                <input type="text" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div>
                                <label class="block text-sm font-medium mb-2">Last Name *</label>
                                <input type="text" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium mb-2">Email *</label>
                                <input type="email" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium mb-2">Phone Number *</label>
                                <input type="tel" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium mb-2">Street Address *</label>
                                <input type="text" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div>
                                <label class="block text-sm font-medium mb-2">City *</label>
                                <input type="text" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div>
                                <label class="block text-sm font-medium mb-2">Postal Code *</label>
                                <input type="text" required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                            </div>
                            <div class="md:col-span-2">
                                <label class="block text-sm font-medium mb-2">Country *</label>
                                <select required class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-lg focus:outline-none focus:ring-2 focus:ring-pink-600">
                                    <option>Select country</option>
                                    <option>Kenya</option>
                                    <option>United States</option>
                                    <option>United Kingdom</option>
                                </select>
                            </div>
                        </form>
                    </div>

                    <!-- Payment Method -->
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                        <h2 class="text-2xl font-bold mb-6 flex items-center gap-2">
                            <span class="w-8 h-8 bg-pink-600 text-white rounded-full flex items-center justify-center text-sm font-bold">2</span>
                            Payment Method
                        </h2>

                        <div class="space-y-4">
                            <!-- Stripe Card Payment -->
                            <label class="flex items-start gap-4 p-4 border-2 border-gray-200 dark:border-gray-700 rounded-xl cursor-pointer hover:border-pink-600 transition-colors">
                                <input type="radio" name="payment" value="stripe" checked class="mt-1 w-5 h-5 text-pink-600">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2 mb-2">
                                        <span class="font-bold">Credit/Debit Card</span>
                                        <div class="flex gap-1">
                                            <div class="w-8 h-5 bg-blue-600 rounded text-white text-xs flex items-center justify-center font-bold">VISA</div>
                                            <div class="w-8 h-5 bg-red-600 rounded text-white text-xs flex items-center justify-center font-bold">MC</div>
                                        </div>
                                    </div>
                                    <p class="text-sm text-gray-500">Secure payment via Stripe</p>
                                </div>
                            </label>

                            <!-- M-Pesa -->
                            <label class="flex items-start gap-4 p-4 border-2 border-gray-200 dark:border-gray-700 rounded-xl cursor-pointer hover:border-pink-600 transition-colors">
                                <input type="radio" name="payment" value="mpesa" class="mt-1 w-5 h-5 text-pink-600">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2 mb-2">
                                        <span class="font-bold">M-Pesa</span>
                                        <div class="px-2 py-1 bg-green-600 text-white text-xs rounded font-bold">KE</div>
                                    </div>
                                    <p class="text-sm text-gray-500">Pay with your M-Pesa mobile money</p>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Order Summary Sidebar -->
                <div class="lg:col-span-1">
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6 sticky top-24">
                        <h2 class="text-2xl font-bold mb-6">Order Summary</h2>

                        <!-- Items -->
                        <div class="space-y-4 mb-6">
                            @foreach (range(1, 3) as $i)
                                <div class="flex gap-4">
                                    <div class="w-16 h-16 bg-gradient-to-br from-gray-100 to-gray-200 dark:from-gray-700 dark:to-gray-600 rounded-lg flex items-center justify-center flex-shrink-0">
                                        <svg class="w-8 h-8 text-gray-300" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                                        </svg>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <h4 class="font-medium text-sm truncate">Premium Product {{ $i }}</h4>
                                        <p class="text-xs text-gray-500">Qty: {{ $i }}</p>
                                    </div>
                                    <span class="font-bold">${{ sprintf('%.2f', 20 * $i) }}</span>
                                </div>
                            @endforeach
                        </div>

                        <div class="space-y-3 mb-6 pb-6 border-b border-gray-200 dark:border-gray-700">
                            <div class="flex justify-between text-sm">
                                <span>Subtotal</span>
                                <span class="font-medium">$120.00</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span>Shipping</span>
                                <span class="font-medium text-green-600">Free</span>
                            </div>
                            <div class="flex justify-between text-sm">
                                <span>Tax</span>
                                <span class="font-medium">$12.00</span>
                            </div>
                        </div>

                        <div class="flex justify-between items-center mb-6">
                            <span class="text-lg font-bold">Total</span>
                            <span class="text-3xl font-bold text-pink-600">$132.00</span>
                        </div>

                        <button class="w-full py-4 bg-gradient-to-r from-pink-600 to-purple-600 text-white rounded-full font-bold shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all mb-3">
                            Complete Order
                        </button>

                        <div class="flex items-center justify-center gap-2 text-sm text-gray-500">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                            <span>Secure SSL encrypted checkout</span>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        @include('partials.footer')
    </body>
</html>
