<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'name' => 'Admin User',
                'role' => 'admin',
                'designation' => 'Manager',
                'code' => '100',
                'basic_pay' => 15000.00,
                'password' => 'password',
            ],
            [
                'name' => 'Pato',
                'role' => 'employee',
                'designation' => 'Hair Stylist',
                'code' => '101',
                'basic_pay' => 12000.00,
                'password' => 'password123',
            ],
            [
                'name' => 'Adiella',
                'role' => 'employee',
                'designation' => 'Nail Technician',
                'code' => '102',
                'basic_pay' => 11000.00,
                'password' => 'password123',
            ],
            [
                'name' => 'Christine',
                'role' => 'employee',
                'designation' => 'Beautician',
                'code' => '103',
                'basic_pay' => 10000.00,
                'password' => 'password123',
            ],
            [
                'name' => 'John',
                'role' => 'employee',
                'designation' => 'Barber',
                'code' => '104',
                'basic_pay' => 10500.00,
                'password' => 'password123',
            ],
        ];

        foreach ($users as $userData) {
            User::create($userData);
        }
    }
}
