<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SuppliersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $suppliers = [
            [
                'name' => 'Beauty Supply Co.',
                'contact_person' => 'Jane Smith',
                'email' => 'jane@beautysupply.com',
                'phone' => '+1234567890',
                'address' => '123 Beauty Street, City',
                'tax_id' => 'TAX-001',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Hair Products Ltd',
                'contact_person' => 'John Doe',
                'email' => 'john@hairproducts.com',
                'phone' => '+1234567891',
                'address' => '456 Hair Avenue, City',
                'tax_id' => 'TAX-002',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Spa Essentials Inc',
                'contact_person' => 'Mary Johnson',
                'email' => 'mary@spaessentials.com',
                'phone' => '+1234567892',
                'address' => '789 Spa Road, City',
                'tax_id' => 'TAX-003',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Nail Art Supplies',
                'contact_person' => 'Bob Wilson',
                'email' => 'bob@nailart.com',
                'phone' => '+1234567893',
                'address' => '321 Nail Street, City',
                'tax_id' => 'TAX-004',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Professional Equipment Co',
                'contact_person' => 'Alice Brown',
                'email' => 'alice@proequipment.com',
                'phone' => '+1234567894',
                'address' => '654 Equipment Blvd, City',
                'tax_id' => 'TAX-005',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('suppliers')->insert($suppliers);
    }
}
