<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class InventoryItemsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get supplier IDs
        $suppliers = DB::table('suppliers')->pluck('id')->toArray();

        if (empty($suppliers)) {
            $this->command->warn('No suppliers found. Please run SuppliersSeeder first.');
            return;
        }

        $items = [
            [
                'name' => 'Professional Hair Dryer',
                'sku' => 'HAIR-001',
                'description' => '2000W professional hair dryer with ionic technology',
                'category' => 'Hair Products',
                'unit' => 'pcs',
                'supplier_id' => $suppliers[0] ?? null,
                'quantity' => 15,
                'reorder_level' => 5,
                'minimum_stock' => 3,
                'buying_price' => 45.00,
                'selling_price' => 89.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890001',
                'location' => 'Shelf A1',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Keratin Hair Treatment Set',
                'sku' => 'HAIR-002',
                'description' => 'Complete keratin treatment kit for damaged hair',
                'category' => 'Hair Products',
                'unit' => 'set',
                'supplier_id' => $suppliers[1] ?? null,
                'quantity' => 8,
                'reorder_level' => 3,
                'minimum_stock' => 2,
                'buying_price' => 120.00,
                'selling_price' => 199.99,
                'markup_percentage' => 67,
                'barcode' => '1234567890002',
                'location' => 'Shelf A2',
                'expiry_date' => now()->addMonths(24)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Gel Nail Polish Set (12 colors)',
                'sku' => 'NAIL-001',
                'description' => 'Professional gel nail polish set with UV light',
                'category' => 'Nail Care',
                'unit' => 'set',
                'supplier_id' => $suppliers[3] ?? null,
                'quantity' => 20,
                'reorder_level' => 5,
                'minimum_stock' => 3,
                'buying_price' => 35.00,
                'selling_price' => 69.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890003',
                'location' => 'Shelf B1',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Facial Cleanser - Organic',
                'sku' => 'SKIN-001',
                'description' => 'Organic facial cleanser for all skin types 200ml',
                'category' => 'Skin Care',
                'unit' => 'bottle',
                'supplier_id' => $suppliers[2] ?? null,
                'quantity' => 30,
                'reorder_level' => 10,
                'minimum_stock' => 5,
                'buying_price' => 12.00,
                'selling_price' => 24.99,
                'markup_percentage' => 108,
                'barcode' => '1234567890004',
                'location' => 'Shelf C1',
                'expiry_date' => now()->addMonths(18)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Anti-Aging Serum',
                'sku' => 'SKIN-002',
                'description' => 'Premium anti-aging serum with vitamin C 30ml',
                'category' => 'Skin Care',
                'unit' => 'bottle',
                'supplier_id' => $suppliers[2] ?? null,
                'quantity' => 12,
                'reorder_level' => 5,
                'minimum_stock' => 3,
                'buying_price' => 45.00,
                'selling_price' => 89.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890005',
                'location' => 'Shelf C2',
                'expiry_date' => now()->addMonths(24)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Makeup Brush Set (15 pieces)',
                'sku' => 'MAKE-001',
                'description' => 'Professional makeup brush set with leather case',
                'category' => 'Makeup',
                'unit' => 'set',
                'supplier_id' => $suppliers[0] ?? null,
                'quantity' => 18,
                'reorder_level' => 5,
                'minimum_stock' => 3,
                'buying_price' => 25.00,
                'selling_price' => 49.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890006',
                'location' => 'Shelf D1',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Foundation - Medium Tone',
                'sku' => 'MAKE-002',
                'description' => 'Long-lasting liquid foundation 30ml',
                'category' => 'Makeup',
                'unit' => 'bottle',
                'supplier_id' => $suppliers[0] ?? null,
                'quantity' => 25,
                'reorder_level' => 8,
                'minimum_stock' => 5,
                'buying_price' => 18.00,
                'selling_price' => 35.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890007',
                'location' => 'Shelf D2',
                'expiry_date' => now()->addMonths(12)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Styling Chair - Hydraulic',
                'sku' => 'TOOL-001',
                'description' => 'Professional hydraulic styling chair with footrest',
                'category' => 'Tools & Equipment',
                'unit' => 'pcs',
                'supplier_id' => $suppliers[4] ?? null,
                'quantity' => 4,
                'reorder_level' => 1,
                'minimum_stock' => 1,
                'buying_price' => 250.00,
                'selling_price' => 499.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890008',
                'location' => 'Storage Room',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Professional Hair Scissors',
                'sku' => 'TOOL-002',
                'description' => 'Japanese steel professional cutting scissors 6 inch',
                'category' => 'Tools & Equipment',
                'unit' => 'pcs',
                'supplier_id' => $suppliers[4] ?? null,
                'quantity' => 10,
                'reorder_level' => 3,
                'minimum_stock' => 2,
                'buying_price' => 35.00,
                'selling_price' => 69.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890009',
                'location' => 'Shelf E1',
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Aromatherapy Essential Oil Set',
                'sku' => 'SPA-001',
                'description' => 'Set of 6 essential oils for aromatherapy',
                'category' => 'Spa Products',
                'unit' => 'set',
                'supplier_id' => $suppliers[2] ?? null,
                'quantity' => 15,
                'reorder_level' => 5,
                'minimum_stock' => 3,
                'buying_price' => 30.00,
                'selling_price' => 59.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890010',
                'location' => 'Shelf F1',
                'expiry_date' => now()->addMonths(36)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Massage Oil - Lavender',
                'sku' => 'SPA-002',
                'description' => 'Relaxing lavender massage oil 500ml',
                'category' => 'Spa Products',
                'unit' => 'bottle',
                'supplier_id' => $suppliers[2] ?? null,
                'quantity' => 22,
                'reorder_level' => 8,
                'minimum_stock' => 5,
                'buying_price' => 15.00,
                'selling_price' => 29.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890011',
                'location' => 'Shelf F2',
                'expiry_date' => now()->addMonths(24)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Shampoo - Sulfate Free',
                'sku' => 'HAIR-003',
                'description' => 'Professional sulfate-free shampoo 1L',
                'category' => 'Hair Products',
                'unit' => 'bottle',
                'supplier_id' => $suppliers[1] ?? null,
                'quantity' => 2,
                'reorder_level' => 10,
                'minimum_stock' => 5,
                'buying_price' => 20.00,
                'selling_price' => 39.99,
                'markup_percentage' => 100,
                'barcode' => '1234567890012',
                'location' => 'Shelf A3',
                'expiry_date' => now()->addMonths(18)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Hair Conditioner - Deep Repair',
                'sku' => 'HAIR-004',
                'description' => 'Deep repair conditioner for damaged hair 1L',
                'category' => 'Hair Products',
                'unit' => 'bottle',
                'supplier_id' => $suppliers[1] ?? null,
                'quantity' => 0,
                'reorder_level' => 10,
                'minimum_stock' => 5,
                'buying_price' => 22.00,
                'selling_price' => 44.99,
                'markup_percentage' => 104,
                'barcode' => '1234567890013',
                'location' => 'Shelf A4',
                'expiry_date' => now()->addMonths(18)->format('Y-m-d'),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($items as $item) {
            DB::table('inventory_items')->insert($item);
        }

        $this->command->info('Successfully seeded ' . count($items) . ' inventory items.');
    }
}
