<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('inventory_item_id')->constrained('inventory_items')->onDelete('cascade');
            $table->integer('user_id'); // Who made the change
            $table->foreignId('sale_id')->nullable()->constrained('sales')->onDelete('set null');

            $table->foreign('user_id')->references('user_id')->on('users')->onDelete('cascade');

            $table->enum('type', ['in', 'out', 'adjustment', 'return', 'damage', 'expired']);
            $table->decimal('quantity', 10, 2);
            $table->decimal('previous_quantity', 10, 2);
            $table->decimal('new_quantity', 10, 2);

            $table->text('reason')->nullable();
            $table->string('reference_number')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_movements');
    }
};
