<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('signins', function (Blueprint $table): void {
            $table->increments('signin_id');
            $table->integer('user_id');
            $table->boolean('status')->default(false);
            $table->boolean('approved')->default(false);
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->string('location_address', 500)->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();

            $table->index('user_id', 'fk_signins_user');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('signins');
    }
};
