<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('completions', function (Blueprint $table): void {
            $table->increments('completions_id');
            $table->integer('service_id');
            $table->integer('user_id');
            $table->decimal('charged', 10, 2);
            $table->timestamp('date')->useCurrent();
            $table->text('notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->boolean('approved')->default(false);

            $table->index('service_id');
            $table->index('user_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('completions');
    }
};
