<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Commission;
use App\Models\Service;
use App\Models\Completion;
use App\Models\Expense;
use App\Models\Payment;
use App\Models\Signin;
use App\Observers\CommissionObserver;
use App\Observers\ServiceObserver;
use App\Observers\CompletionObserver;
use App\Observers\ExpenseObserver;
use App\Observers\PaymentObserver;
use App\Observers\SigninObserver;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register Model Observers to handle trigger logic
        Commission::observe(CommissionObserver::class);
        Service::observe(ServiceObserver::class);
        Completion::observe(CompletionObserver::class);
        Expense::observe(ExpenseObserver::class);
        Payment::observe(PaymentObserver::class);
        Signin::observe(SigninObserver::class);
    }
}
