<?php

namespace App\Observers;

use App\Models\Payment;
use Carbon\Carbon;

class PaymentObserver
{
    /**
     * Handle the Payment "creating" event.
     * Adjust timestamps with timezone (+7 hours).
     */
    public function creating(Payment $payment): void
    {
        if ($payment->created_at) {
            $payment->created_at = Carbon::parse($payment->created_at)->addHours(7);
        }

        if ($payment->updated_at) {
            $payment->updated_at = Carbon::parse($payment->updated_at)->addHours(7);
        }

        if ($payment->payment_date) {
            $payment->payment_date = Carbon::parse($payment->payment_date)->addHours(7);
        }
    }

    /**
     * Handle the Payment "updating" event.
     * Adjust updated_at timestamp with timezone (+7 hours).
     */
    public function updating(Payment $payment): void
    {
        if ($payment->updated_at) {
            $payment->updated_at = Carbon::parse($payment->updated_at)->addHours(7);
        }
    }
}
