<?php

namespace App\Observers;

use App\Models\Expense;
use Carbon\Carbon;

class ExpenseObserver
{
    /**
     * Handle the Expense "creating" event.
     * Adjust timestamps with timezone (+7 hours).
     */
    public function creating(Expense $expense): void
    {
        if ($expense->created_at) {
            $expense->created_at = Carbon::parse($expense->created_at)->addHours(7);
        }

        if ($expense->updated_at) {
            $expense->updated_at = Carbon::parse($expense->updated_at)->addHours(7);
        }

        if ($expense->expense_date) {
            $expense->expense_date = Carbon::parse($expense->expense_date)->addHours(7);
        }
    }

    /**
     * Handle the Expense "updating" event.
     * Adjust updated_at timestamp with timezone (+7 hours).
     */
    public function updating(Expense $expense): void
    {
        if ($expense->updated_at) {
            $expense->updated_at = Carbon::parse($expense->updated_at)->addHours(7);
        }
    }
}
