<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'sale_id',
        'inventory_item_id',
        'item_name',
        'sku',
        'quantity',
        'unit_price',
        'buying_price',
        'subtotal',
        'discount',
        'total',
        'profit',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'unit_price' => 'decimal:2',
        'buying_price' => 'decimal:2',
        'subtotal' => 'decimal:2',
        'discount' => 'decimal:2',
        'total' => 'decimal:2',
        'profit' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the sale that owns this item.
     */
    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

    /**
     * Get the inventory item.
     */
    public function inventoryItem()
    {
        return $this->belongsTo(InventoryItem::class);
    }

    /**
     * Boot method to calculate profit.
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($saleItem) {
            // Calculate profit
            $saleItem->profit = ($saleItem->unit_price - $saleItem->buying_price) * $saleItem->quantity - $saleItem->discount;
        });
    }
}
