<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Commission extends Model
{
    use HasFactory;

    protected $primaryKey = 'commission_id';

    protected $fillable = [
        'user_id',
        'completions_id',
        'commission_amount',
    ];

    protected function casts(): array
    {
        return [
            'commission_amount' => 'decimal:2',
            'created_at' => 'datetime',
            'updated_at' => 'datetime',
        ];
    }

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    public function completion()
    {
        return $this->belongsTo(Completion::class, 'completions_id', 'completions_id');
    }
}
