<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ProductController extends Controller
{
    /**
     * Display all products in shop
     */
    public function index(Request $request)
    {
        // Get filter parameters
        $category = $request->query('category');
        $brand = $request->query('brand');
        $filter = $request->query('filter');

        return view('shop', compact('category', 'brand', 'filter'));
    }

    /**
     * Display products by category
     */
    public function category($category)
    {
        // Validate category
        $validCategories = ['skincare', 'haircare', 'makeup', 'tools'];

        if (!in_array($category, $validCategories)) {
            abort(404);
        }

        return view('shop', ['category' => $category]);
    }

    /**
     * Display products by brand
     */
    public function brand($brand)
    {
        return view('shop', ['brand' => $brand]);
    }

    /**
     * Display featured products
     */
    public function featured()
    {
        return view('shop', ['filter' => 'featured']);
    }

    /**
     * Display deals
     */
    public function deals()
    {
        return view('shop', ['filter' => 'deals']);
    }

    /**
     * Search products
     */
    public function search(Request $request)
    {
        $query = $request->query('q');

        return view('shop', ['search' => $query]);
    }

    /**
     * Display single product
     */
    public function show($id)
    {
        // TODO: Fetch product from database
        return view('product-detail', ['productId' => $id]);
    }

    /**
     * Display all brands
     */
    public function brands()
    {
        return view('brands');
    }
}
